/*
 * qsortdemo.c
 *
 * Brzo sortiranje niza brojeva primenom bibliotecke rutine
 * qsort().
 */

#include <stdio.h>
#include <stdlib.h>

/* prototipovi funkcija */
int porediceo(int *, int *);

int
main (void)
{
    int n, *pok;    /* brojac petlje i pokazivac */
	int velicina;	/* velicina niza u elementima */

	/* nesortirani niz celih brojeva */
	static int broj[] = {
        400, 1, 230, -16, 81, 120, 33, -54, 60
	};
                    
	/* izracunaj velicinu niza */
	velicina = sizeof broj / sizeof (int);
	/* prikazi sadrzaj nesortiranog niza */
	puts("\nNesortirani Niz:");
    for (n = velicina, pok = broj; n-- > 0; ++pok)
		printf("%5d   ", *pok);
	putchar('\n');

	/* primeni qsort() da sortiras niz */
	qsort((void *)broj, (size_t)velicina, sizeof (int),
		porediceo);
	/* prikazi sadrzaj sortiranog niza */
	puts("\nSortirani Niz:");
    for (n = velicina, pok = broj; n-- > 0; ++pok)
		printf("%5d   ", *pok);
	putchar('\n');
	
	return EXIT_SUCCESS;
}

int
porediceo(int *n1, int *n2)
{
	if (*n1 > *n2)
		return 1;
	else if (*n1 < *n2)
        return -1;
	else
		return 0;
}
