/*
 * prik.c
 *
 * Jednostavan progam za demonstraciju kako operativni 
 * sistem predaje programu podatke iz komandne linije.
 */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef enum {NETACNO, TACNO} LOGIC;

int
main (int argc, char *argv[])
{
	int zn;					/* ulazno/izlazni znak */
    LOGIC prikUprav;        /* prikazi upravljacke znakove za TACNO */
	char *imefajl;			/* pokazivac na ime fajla */
	FILE *pf;				/* pokazivac na fajl */

	/* obrada komandne linije */
	prikUprav = NETACNO;
	if (argc < 2 || argc > 3) {
		fputs("Pravilan poziv je: prik [-c] fajl\n", stderr);
		exit(EXIT_FAILURE);
	}
	switch (argc) {
	case 2:
		imefajl = argv[1];
		break;
	case 3:
		prikUprav = TACNO;
		imefajl = argv[2];
		break;
	}

    /* otvori fajl radi citanja */
	if ((pf = fopen(imefajl, "r")) == NULL) {
		fprintf(stderr, "Ne mogu da otvorim %s\n", imefajl);
		exit(EXIT_FAILURE);
	}

	/* kopiraj fajl na standardni izlaz */
	while ((zn = fgetc(pf)) != EOF)
		if (prikUprav == TACNO && iscntrl(zn))
			printf("<%i>", zn);
		else
			putchar(zn);
	if (ferror(pf)) {
        fprintf(stderr, "Greska pri citanju %s\n", imefajl);
		clearerr(pf);
	}
	/* zatvori fajl i izadji */
	fclose (pf);
	if (ferror(pf)) {
        fprintf(stderr, "Greska pri zatvaranju %s\n",
		  imefajl);
	}
	return EXIT_SUCCESS;
}
