/*
 * pisifajl.c
 *
 * Upis teksta sa standardnog ulaza u imenovani fajl.
 */

#include <stdio.h>
#include <stdlib.h>

#if defined (MSDOS)
	#define MAXPUT 64
#else
	#define MAXPUT 128
#endif

int
main (void)
{
	int zn;
	char ime[MAXPUT];
	FILE *pf;

	/* ucitaj od korisnika ime fajla */
	printf("Ime fajla: ");
	gets(ime);

	/* proveri ime i pokusaj da otvoris fajl */
	if (ime[0] == '\0') {
		fprintf(stderr, "Nije uneto ime\n");
		exit (EXIT_SUCCESS);
	}
	pf = fopen(ime, "w");
	if (pf == NULL) {
        fprintf(stderr, "Otvaranje %s nije uspelo.\n", ime);
		exit (EXIT_FAILURE);
	}

	/* upisi ulazne podatke u fajl */
    while ( (zn = getchar() ) != EOF)
		putc(zn, pf);
	
	/* zatvori fajl */
	fclose(pf);

	return EXIT_SUCCESS;
}
