/*
 * otpornik.c
 *
 * Konvertuje oznake boja otpornika u vrednost otpora. 
 * Ovaj program uzima listu od tri boje i prikazuje vrednost 
 * u Omima. Oznaku tolerancije ne uzima u obzir.
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#define MAXIME 7

/* tabela pretrazivanja */
struct otpornik_st {
	char *boja;
	int cifra;
	double mnoz;
} otpornik[] = {
	"crna",		0,  1.0,
	"braon",		1,  10.0,
	"crvena",   	2,  100.0,
    "oranz",        3,  1000.0,
	"zuta",		4,  10000.0,
	"zelena",   	5,  100000.0,
	"plava",		6,  1000000.0,
	"lila",			7,  10000000.0,
	"siva",		8,  0.01,
	"bela",		9,  0.1,
	NULL,		 -1, -1.0,
};

/* prototipovi funkcija */
int boja_u_cifru(char *);
double boja_u_mnoz(char *);
void greska(char *);

int
main (void)
{
	double oma;
	int cifra1, cifra2;
	double mnoz;
	char boja1[MAXIME], boja2[MAXIME], boja3[MAXIME];

	/* ucitaj oznaku boje */
    puts("Unesite boje (Primer: braon crna crvena) + Return:");
	scanf("%s %s %s", boja1, boja2, boja3);

	/* konvertuj oznake u vrednost */
	if ((cifra1 = boja_u_cifru(boja1)) == -1)
		greska(boja1);
	if ((cifra2 = boja_u_cifru(boja2)) == -1)
		greska(boja2);
	if ((mnoz = boja_u_mnoz(boja3)) == -1.0)
		greska(boja3);
	oma = (10 * cifra1 + cifra2) * mnoz;
	printf("Vrednost = %.2lf Oma\n", oma);

	return EXIT_SUCCESS;
}

int
boja_u_cifru (char *boja)
{
    struct otpornik_st *p;

    /* potrazi odgovarajuci kod u tabeli */
    p = otpornik;
    while (p -> boja != NULL) {
        if (strcmp (p->boja, boja) == 0)
            break;
        ++p;
    }

    return p->cifra;
}

double
boja_u_mnoz (char *boja)
{
    struct otpornik_st *p;

    /* potrazi odgovarajuci kod u tabeli */
    p = otpornik;
    while (p->boja != NULL) {
        if (strcmp (p->boja, boja) == 0)
            break;
        ++p;
    }

    return p->mnoz;
}

void
greska (char *tekst)
{
    fprintf (stderr, "Pogresno zadata boja: %s\n", tekst);
    exit (EXIT_FAILURE);
}
