 /*
 * okvirtekst.c
 *
 * Demonstracija kako se koriste funkcije da se program organizuje
 * u celine koje interaguju da bi obavile neki zadatak (prikaz
 * teksta u oviru).
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* simbolicke konstante */
#define SIROKV 3
#define HLIN  '-'
#define VLIN  '|'
#define UGAO   '+'
#define PRAZNO ' '

/* prototipovi funkcija */
void znak(int, char);
void hokvir(int);
void pisitekst(char[]);

int
main (void)
{
	int sirina;
	static char tekst[] = {
		"Ovo je zgodna trivijalna poruka"
	};

	/* izracunaj duzinu i poziciju */
	sirina = strlen(tekst) + 2 * SIROKV;

    /* prikazi gornji deo okvira */
	hokvir(sirina);

	/* prikazi tekst */
	pisitekst(tekst);

    /* prikazi donji okvir */
	hokvir(sirina);

	return EXIT_SUCCESS;
}

/* prikazivanje zadati broj puta zadatog znaka */
void
znak (int n, char ch)
{
    while (n-- > 0)
		putchar (ch);
}

/* prikazivanje horizontalnog okvira */
void
hokvir (int w)
{
	putchar(UGAO);	       /* prikazi ugao */
    znak(w - 2, HLIN);     /* prikazi horizontalnu liniju */
	putchar(UGAO);	       /* prikazi ugao */
    putchar('\n');         /* predji u novi red */
}

/* 
 * prikazivanje tekstualne poruke u sredini izmedju levog i 
 * desnog okvira
 */
void
pisitekst( char poruka[])
{
	/* prikazi levi okvir */
	putchar(VLIN);
    znak(SIROKV - 1, PRAZNO);

	/* prikazi tekst u sredini */
	printf("%s", poruka);

	/* prikazi desni okvir */
    znak(SIROKV - 1, PRAZNO);
	putchar(VLIN);
	putchar('\n');
}
