/*
 * okruzdemo.c
 *
 * Prikazi promenljive i njihove vrednosti iz 
 * korisnikovog okruzenja
 */

#define MAXIME 25 
#define MSDOS
 
#include <stdio.h>
#include <stdlib.h>

#if defined (MSDOS)
#include <ctype.h>
#endif

int
main (int argc, char **argv, char **envp)
{
	char *okruz;	/* pokazivac na znakovni niz */
    char **po;      /* pokazivac bloka podataka o okruzenju */
#if defined(MSDOS)
	char *pz;
#endif

	/* ulazni bafer */
	char imeprom[MAXIME+1];

    /* prikazi listu podataka o okruzenju */
	po = envp;
	while (*po++)
		puts(*po);

    /* demonstracija koriscenja getenv() */
    printf("Ime promenljive: ");
    gets(imeprom);

#if defined(MSDOS)
    /* konverzija imena promenljive u velika slova za DOS */
	for (pz = imeprom; *pz != '\0'; ++pz)
		*pz = (char)toupper((int)*pz);
#endif

	if ((okruz = getenv(imeprom)) != NULL)
		printf("%s=%s\n", imeprom, okruz);
	else {
		fprintf(stderr,
            "Promenljiva %s nije nadjena\n", imeprom);
		exit(EXIT_FAILURE);
	}

	return EXIT_SUCCESS;
}
