
/* ocene.c
 *
 * Prikupljanje rezultata od korisnika (slusaoca muzike, gledaoca
 * filmova, itd.), analiziranje podataka i formiranje izvestaja.
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#define OPSEG 10
#define BRZNAK 20

int
main (void)
{
	int kofa[OPSEG] = {0};
	char ulbaf[BRZNAK];
	int broj = 0;
	int ocena;
	int n;
    /* prikupi sirove podatke */
	printf("\nPROGRAM OCENE\n");
	printf("Unesite ocenu u opsegu od 0 do 9\n");
	printf("Potvrdite svaki podatak tasterom Return\n");
    printf("Unosenje se zavrsava pritiskom samo tastera Return\n");
	while (1) {
        /* Upit i prihvatanje ulaznog podatka */
		printf("Ocena: ");
		if (gets(ulbaf) == NULL) {
            fprintf(stderr, "GRESKA: neispravno ucitavanje podataka\n");
			continue;
		}

        /* provera da li je komanda za kraj (znak koji nije cifra) */
        if ( !(isdigit(ulbaf[0])) ) {
			putchar('\n');
			break;
		}

		/* konverzija ulaznog znakovnog niza u ceo broj */
		ocena = atoi(ulbaf);

		/* proveri da li je podatak u opsegu; 
		ako jeste prihvati ga */
        if ( (ocena >= 0) && (ocena <OPSEG) ) {
			++kofa[ocena];
			++broj;
		}
		else {
            fprintf(stderr, "GRESKA: podatak izvan opsega\n");
            continue;
		}
	}

	/* izvestaj o rezultatima */
	printf("\nREZULTATI:\nOcena\tBroj\n");
    for (n = 0; n < OPSEG; ++n)
		printf("%d\t%d\n", n, kofa[n]);
	printf("\n%d ocena prikazano\n", broj);
	return EXIT_SUCCESS;
}
