/*
 * listfajl.c
 *
 * Prikazivanje sadrzaja fajla na standardni izlaz.
 */

#include <stdio.h>
#include <stdlib.h>

#if defined (MSDOS)
	#define MAXPUT 64
#else
	#define MAXPUT 128
#endif

int
main (void)
{
	int zn;
	char ime[MAXPUT];
	FILE *pf;

	/* ucitaj od korisnika ime fajla */
	printf("Ime fajla: ");
	gets(ime);

    /* proveri ime i pokusaj da otvoris fajl */
	if (ime[0] == '\0') {
		fprintf(stderr, "Nije uneto ime\n");
		exit (EXIT_SUCCESS);
	}
	pf = fopen(ime, "r");
	if (pf == NULL) {
        fprintf(stderr, "Otvaranje %s nije uspelo.\n", ime);
		exit (EXIT_FAILURE);
	}

	/* prikazi sadrzaj fajla */
    while ( (zn = fgetc(pf)) != EOF)
		putchar(zn);
	
	return EXIT_SUCCESS;
}
