/*
 * kartoteka.c
 *
 * Ovo je krajnje pojednostavljena kartoteka koja demonstrira
 * primenu povezane liste i tehnike dinamickog odvajanja i
 * vracanja memorije
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BRBAJTA 128
#define VELIME 30
#define VELTELEF 20

/* sablon strukture */
typedef struct karton_st {
	char ime[VELIME];
	char telefon[VELTELEF];
	struct karton_st *sledeci;
} KARTON;

/* promenljive za kartoteku */
KARTON pocetakliste, *pocetak, *tekuci;

/* prototipovi funkcija */
static int dodaj_ka(void);
static int pronadji_karton(void);
static int listaj_kartoteku(void);
static int citaj_kart(char *);
static int pisi_kart(char *);
KARTON *umetni_cvor(KARTON *);
void greska(char *);
static void prik_zapis(char *, char *);

char odgovor[BRBAJTA + 1];

int
main (int argc, char *argv[])
{
	int pk;
	static char fajl[BRBAJTA + 1] = {
		"kartoteka.dat"
	};

	/* provera imena koje zadaje korisnik */
	if (argc == 2)
		strcpy(fajl, argv[1]);

	/* priprema prazne liste */
	tekuci = pocetak = &pocetakliste;
	pocetak->sledeci = pocetak;

    /* ucitavanje podataka u bafer */
	pk = citaj_kart(fajl);
	if (pk)
        greska("Neuspesno citanje iz kartoteke");
	/* prikazi uputstvo */
	puts("Komande za KARTOTEKU:");
    puts(" d = dodavanje kartona u kartoteku");
    puts(" p = pronalazenje kartona na osnovu imena");
    puts(" l = listanje kartoteke");
    puts(" k = kraj rada (cuvanje izmena)");
    puts(" i = izlaz (bez cuvanja izmena)\n");
	while(1) {
		/* prihvati korisnikovu komandu */
		printf("Komanda (d, p, l, k, ili i): ");
		gets(odgovor);

		/* obrada komande */
		switch (odgovor[0]) {
		case 'd':
		case 'D':
            dodaj_ka();
			break;
		case 'p':
		case 'P':
			pronadji_karton();
			break;
		case 'l':
		case 'L':
			listaj_kartoteku();
			break;
		case 'k':
		case 'K':
            /* sacuvaj izmene i izadji */
			pisi_kart(fajl);
                                                return EXIT_SUCCESS;
		case 'i':
		case 'I':
            /* izadji bez cuvanja izmena */
			return EXIT_SUCCESS;
		default:
			/* zanemari */
			break;
		} /* kraj switch-a */
	} /* kraj while-a */

	return EXIT_SUCCESS;
}

/* ucitaj kartoteku u bafer */
static int
citaj_kart(char *imefajl)
{
	char *pz;
	FILE *pf;
	char red[BRBAJTA+1];
	int pk = 0;
	KARTON *priv;

    /* otvori fajl radi citanja */
	pf = fopen(imefajl, "r");
	if (pf == NULL)
		return 0;		/* nije greska */

	/* ucitaj podatke u bafer */
	while (fgets(red, BRBAJTA + 1, pf) != NULL) {
		/* ukloni NL */
		pz = red;
		while (*pz != '\n' && *pz != '\0')
			++pz;
		*pz = '\0';

		/* odvoji mesto za cvor i pripremi pokazivac 
            na njega */
		priv = umetni_cvor(tekuci);
		if (priv == NULL)
            greska("Nema dovoljno memorije");
		tekuci = priv;

		/* kopiraj podatke u karton */
		strcpy(tekuci->ime, strtok(red, "\t"));
		strcpy(tekuci->telefon, strtok(NULL, "\t"));
	}

    /* zatvaranje fajla */
	fclose(pf);
	if (ferror(pf))
        greska("Zatvaranje fajla nije uspelo");

	return pk;
}


/* dodaj novi element u listu */
static int
dodaj_ka(void)
{
	int pk = 0;
	KARTON *priv;

	priv = umetni_cvor(tekuci);
	if (priv == NULL) {
        fprintf(stderr, "Nema dovoljno memorije");
		++pk;
	}
	else {
		tekuci = priv;
		/* ime i adresa osobe */
		printf("Ime: ");
		gets(odgovor);
        strcpy(tekuci->ime, odgovor);
		printf("Telefon: ");
		gets(odgovor);
        strcpy(tekuci->telefon, odgovor);
	}

	return 0;
}

/* prikazi celu kartoteku */
static int
listaj_kartoteku(void)
{
	int pk = 0;
	KARTON *priv;

	priv = pocetak;
    if (priv->sledeci == pocetak) {
		puts("Lista je prazna");
		++pk;
	}
	else
        while (priv->sledeci != pocetak) {
            priv = priv->sledeci;
            prik_zapis(priv->ime, priv->telefon);
		}

	return pk;
}

/* upisi podatke iz bafera u fajl */
static int
pisi_kart(char *imefajl)
{
	FILE *pf;
	int pk = 0;
    KARTON *priv;

    /* otvori kartoteku radi citanja */
	pf = fopen(imefajl, "w");
	if (pf == NULL) {
		fprintf(stderr, "Ne mogu da otvorim %s\n", imefajl);
		return ++pk;
	}

	/* upisi podatke u bafer */
	priv = pocetak;
    if (priv->sledeci == pocetak) {
		puts("Lista je prazna");
		++pk;
	}
	else
        while (priv->sledeci != pocetak) {
            priv = priv->sledeci;
			fprintf(pf, "%s\t%s\n",
                priv->ime, priv->telefon);
		}

	/* zatvori kartoteku */
	fclose(pf);
	if (ferror(pf))
		greska("Ne mogu da zatvorim fajl");

	return pk;
}

/* pronadji i stampaj element liste */
static int
pronadji_karton(void)
{
	int pk = 0;
	int pogodaka = 0;
	int duz;
	char *pz;
	KARTON *priv;

	priv = pocetak;
    if (priv->sledeci == pocetak) {
		puts("Lista je prazna");
		return ++pk;
	}

	printf("Ime koje se trazi: ");
	gets(odgovor);
	duz = strlen(odgovor);
    while(priv->sledeci != pocetak) {
        priv = priv->sledeci;
        pz = priv->ime;
		while (*pz != '\0') {
			if (strncmp(pz, odgovor, duz) == 0) {
                prik_zapis(priv->ime, priv->telefon);
				++pogodaka;
			}
			++pz;
		}
	}
	if (pogodaka == 0)
		puts("Karton nije pronadjen");

	return pk;
}

static void
prik_zapis (char *zn1, char *zn2)
{
	printf ("%-*s\t%-*s\n",
		VELIME, zn1, VELTELEF, zn2);
}

KARTON *
umetni_cvor (KARTON *listp)
{
	KARTON *novi;

    /* odvoji prostor za novi cvor */
	novi = (KARTON *) malloc (sizeof (KARTON));
	if (novi != NULL) {
		/* povezi cvor u listu */
		novi->sledeci = listp->sledeci;
		listp->sledeci = novi;
	}

	return novi;
}

void
greska (char *poruka)
{
	fprintf (stderr, "GESKA: %s\n", poruka);
	exit (EXIT_FAILURE);
}
