/* Ovo je jedna malo drugacija verzija programa iz knjige. Umesto poziva
   makroa atof () ovde je napisana funkcija float atoff (char *) koja 
   obavlja taj posao. */

/*
 * kalk.c
 *
 * Ovaj program realizuje vrlo jednostavan kalkulator sa cetiri
 * funkcije koji koristi Obratnu Poljsku Notaciju (RPN).
 * On demonstrira primenu rednog izvrsavanja naredbi, 
 * ponavljanja i izbora.
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define VELBAF 15

float atoff (char *s)
{
    float rezultat;
    
    sscanf (s, "%f", &rezultat);
    return rezultat;
}

int main (void)
{
    float broj1, broj2;    /* brojevi */
    int op;                /* operator */
    int ndp = 2;           /* broj decimalnih mesta za izlaz */

	/* ulazni baferi */
	char ulbaf1[VELBAF+1], ulbaf2[VELBAF+1];

	while (1) {
		/* uzmi od korisnika brojeve i operator */
		printf("         Prvi broj: ");
		gets(ulbaf1);
        broj1 = atoff(ulbaf1);

		printf("        Drugi broj: ");
		gets(ulbaf2);
        broj2 = atoff(ulbaf2);

		printf("Operator (I=izlaz): ");
		op = getchar();	/* uzmi znak za operator */
		getchar();			/* odbaci znak za novi red */

		/* obavi racunae i prikazi rezultat */
		switch (op) {
		case 'i':
		case 'I':
			exit(EXIT_SUCCESS);
		case '+':
			printf("%.*lf\n", ndp, broj1 + broj2);
			break;
        case '-':
			printf("%.*lf\n", ndp, broj1 - broj2);
			break;
		case '*':
			printf("%.*lf\n", ndp, broj1 * broj2);
			break;
		case '/':
			if (broj2 != (float)0)
			      	printf("%.*lf\n", ndp, broj1 / broj2);
			else {
				      fprintf(stderr, 
                            " Ne moze se deliti nulom\n");
				      exit (EXIT_FAILURE);
			}
			break;
		default:
			fprintf(stderr, 
                        " Nepoznat operator: %c\n", op);
			break;
		} /* kraj switch-a */

		putchar('\n');     /* napravi malo mesta izmedju
            izvrsavanja */

    } /* kraj while petlje */

    return EXIT_SUCCESS;
		/* Kompajler ce mozda prijaviti warning da je poslednja linija
		   nedostizna, posto se ona zaista nikada nece izvrsiti. */
}
