/*
 * izv2vp.c
 *
 * Konverzija izvornog koda programa u oblik koji odgovara
 * formatu programa Ventura Publisher. Program obavlja sledece:
 *  - stiti simbole @, < i > tako sto ih udvaja
 *  - zamenjuje zavrsetak reda (CR/LF) kodom za vertikalnu
 *    tabulaciju (VT = 11 dec, 0B hex).
 */

#include <stdio.h>
#include <stdlib.h>

#define E_KOM   1
#define E_IZV   2
#define E_CIT   3
#define E_ZATV  4
#define VT      11
/* prototipovi funkcija */
extern void fatal (char *, int);

int
main (int argc, char *argv[])
{
	int zn;
	FILE *pf;

	/* provera sintakse komandne linije */
	if (argc != 2)
		fatal ("Pravilan poziv je: izv2vp izvorni_fajl",
			E_KOM);

	/* otvaranje fajla radi citanja u tekst rezimu */
	pf = fopen(argv[1], "rt");
	if (pf == NULL)
		fatal("Greska u otvaranju izvornog fajla", E_IZV);

	/* Kopiranje izvornog fajla na standardni izlaz */
	while ((zn = fgetc(pf)) != EOF) {
		/* obavi zahtevano prevodjenje */
		switch (zn) {
		case '@':
		case '<':
		case '>':
			/* ove je kodove petrebno udvojiti */
			putchar(zn);
			break;
		case '\n':
			/*
			 * konverzija zavrsetka linije u
			 * znak za vertikalnu tabulaciju
			 */
			putchar(VT);
			continue;
		}
		putchar(zn);
	}

	/* provera greske */
	if (ferror(pf))
		fatal("Greska u citanju izvornog fajla", E_CIT);

	/* zatvaranje fajla */
    if (fclose(pf) != 0)
		fatal("Greska u zatvaranju izvornog faja", E_ZATV);

	return EXIT_SUCCESS;
}
