package cc.dividebyzero.android.cookbook.commons;

import java.util.ArrayList;
import java.util.List;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.TextView;


/**
 * A simple abstract class that allows us to choose Activitys from a list.
 * The list of Activities is generated by the implementing child class.
 * Using this as a Launcher we can easily present different topics of a chapter. 
 * @author Ronan 'zero' Schwarz
 *
 */
@SuppressWarnings("rawtypes")
public abstract class ChapterDashboardActivity extends ListActivity implements OnItemClickListener {

	protected static class CookbookRecipe{
		public CookbookRecipe() {
			//empty default constructor;
		}
		
		public CookbookRecipe(final String title, final Class activity) {
			this.title=title;
			this.activity=activity;
		}
		
		public String title=null;
		public Class activity=null;
	}
	
	
	public class RecipeListAdapter extends ArrayAdapter<CookbookRecipe>{

		private int resource;
		private int textViewResourceId;
		
		public RecipeListAdapter(Context context, int resource,	int textViewResourceId, List<CookbookRecipe> objects) {
			super(context, resource, textViewResourceId, objects);
			//save them as local 'cause they are private in parent class.
			this.resource=resource;
			this.textViewResourceId=textViewResourceId;
		}

		/**
		 * very simple (and slow) getView method.
		 * inflate the given layout resource if convertView is empty,
		 * the fill in title of recipe give at position.
		 */
		@Override
		public View getView(int position, View convertView, ViewGroup parent) {
			if(convertView==null){
				convertView=getLayoutInflater().inflate(resource,  null);				
			}
			final TextView txt=(TextView)convertView.findViewById(textViewResourceId);
			final CookbookRecipe recipe=this.getItem(position);
			txt.setText(recipe.title);
			return convertView;
		}
		
	}
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setListAdapter(new RecipeListAdapter(
				getApplicationContext(), 
				android.R.layout.simple_list_item_1, 
				android.R.id.text1, 
				getRecipeList()
				)
			);
		
		getListView().setOnItemClickListener(this);
	}

	protected abstract ArrayList<CookbookRecipe> getRecipeList();


	public void onItemClick(AdapterView<?> listView, View view, int position, long id) {
		CookbookRecipe recipe= getRecipeList().get(position);
		if(recipe!=null && recipe.activity!=null){
			startActivity(new Intent(getApplicationContext(),recipe.activity));
		}
	}


}
