/*
 * Decompiled with CFR 0.152.
 */
package com.littlefluffytoys.littlefluffylocationlibrary;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.Location;
import android.preference.PreferenceManager;
import android.text.format.DateFormat;
import android.util.Log;
import com.littlefluffytoys.littlefluffylocationlibrary.LocationBroadcastService;
import com.littlefluffytoys.littlefluffylocationlibrary.LocationLibrary;
import com.littlefluffytoys.littlefluffylocationlibrary.LocationLibraryConstants;

public class PassiveLocationChangedReceiver
extends BroadcastReceiver {
    protected static String TAG = "PassiveLocationChangedReceiver";

    public void onReceive(Context context, Intent intent) {
        String key = "location";
        if (intent.hasCategory("INTENT_CATEGORY_ONE_SHOT_UPDATE")) {
            if (LocationLibrary.showDebugOutput) {
                Log.d((String)"LittleFluffyLocationLibrary", (String)(String.valueOf(TAG) + ":onReceive: on-demand location update received"));
            }
            if (LocationLibraryConstants.SUPPORTS_JELLYBEAN_4_2 && intent.hasExtra(key)) {
                if (LocationLibrary.showDebugOutput) {
                    Log.d((String)"LittleFluffyLocationLibrary", (String)(String.valueOf(TAG) + ":onReceive: SUPPORTS_JELLYBEAN_4_2 and contains location key => processing"));
                }
                PassiveLocationChangedReceiver.processLocation(context, (Location)intent.getExtras().get(key));
            } else {
                if (LocationLibrary.showDebugOutput) {
                    Log.d((String)"LittleFluffyLocationLibrary", (String)(String.valueOf(TAG) + ":onReceive: pre-JELLYBEAN_4_2 => wait for update(s) from passive location provider"));
                }
                LocationBroadcastService.forceDelayedServiceCall(context, 30);
            }
        } else if (intent.hasExtra(key)) {
            PassiveLocationChangedReceiver.processLocation(context, (Location)intent.getExtras().get(key));
        } else if (LocationLibrary.showDebugOutput) {
            Log.w((String)"LittleFluffyLocationLibrary", (String)(String.valueOf(TAG) + ":onReceive: Unknown update received"));
        }
    }

    protected static void processLocation(Context context, Location location) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        float lastLat = prefs.getFloat("LFT_SP_KEY_LAST_LOCATION_UPDATE_LAT", -9.223372E18f);
        float lastLong = prefs.getFloat("LFT_SP_KEY_LAST_LOCATION_UPDATE_LNG", -9.223372E18f);
        int lastAccuracy = prefs.getInt("LFT_SP_KEY_LAST_LOCATION_UPDATE_ACCURACY", Integer.MAX_VALUE);
        boolean usePreviousReading = false;
        float thisLat = (float)((int)(location.getLatitude() * 1000000.0)) / 1000000.0f;
        float thisLong = (float)((int)(location.getLongitude() * 1000000.0)) / 1000000.0f;
        int thisAccuracy = (int)location.getAccuracy();
        long thisTime = location.getTime();
        if (lastLat != -9.223372E18f) {
            int distanceBetweenInMetres = (int)(Math.acos(Math.sin(Math.toRadians(thisLat)) * Math.sin(Math.toRadians(lastLat)) + Math.cos(Math.toRadians(thisLat)) * Math.cos(Math.toRadians(lastLat)) * Math.cos(Math.toRadians(thisLong) - Math.toRadians(lastLong))) * 6371.0 * 1000.0);
            if (LocationLibrary.showDebugOutput) {
                Log.d((String)"LittleFluffyLocationLibrary", (String)(String.valueOf(TAG) + ": Distance from last reading: " + distanceBetweenInMetres + "m"));
            }
            if (location.hasAccuracy() && thisAccuracy > lastAccuracy && distanceBetweenInMetres < thisAccuracy) {
                usePreviousReading = true;
            }
        }
        long previousTime = prefs.getLong("LFT_SP_KEY_LAST_LOCATION_UPDATE_TIME", thisTime);
        SharedPreferences.Editor prefsEditor = prefs.edit();
        prefsEditor.putLong("LFT_SP_KEY_LAST_LOCATION_UPDATE_TIME", thisTime);
        if (!usePreviousReading) {
            prefsEditor.putFloat("LFT_SP_KEY_LAST_LOCATION_UPDATE_LAT", thisLat);
            prefsEditor.putFloat("LFT_SP_KEY_LAST_LOCATION_UPDATE_LNG", thisLong);
            prefsEditor.putInt("LFT_SP_KEY_LAST_LOCATION_UPDATE_ACCURACY", thisAccuracy);
            if (LocationLibrary.showDebugOutput) {
                Log.d((String)"LittleFluffyLocationLibrary", (String)(String.valueOf(TAG) + ": Storing location update, lat=" + thisLat + " long=" + thisLong + " accuracy=" + thisAccuracy + " time=" + thisTime + "(" + DateFormat.format((CharSequence)"kk:mm.ss, E", (long)thisTime) + ")"));
            }
        } else if (LocationLibrary.showDebugOutput) {
            Log.d((String)"LittleFluffyLocationLibrary", (String)(String.valueOf(TAG) + ": Storing location update, less accurate so reusing prior location - time=" + thisTime));
        }
        prefsEditor.commit();
        if (LocationLibrary.broadcastEveryLocationUpdate) {
            LocationBroadcastService.sendBroadcast(context, prefs, false);
        }
        if (thisTime - previousTime > LocationLibrary.getAlarmFrequency()) {
            if (LocationLibrary.showDebugOutput) {
                Log.d((String)"LittleFluffyLocationLibrary", (String)(String.valueOf(TAG) + ":processLocation: treating this update as a periodic update"));
            }
            LocationBroadcastService.forceDelayedServiceCall(context, 10);
        }
    }
}

