/*
 * Decompiled with CFR 0.152.
 */
package com.littlefluffytoys.littlefluffylocationlibrary;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.LocationManager;
import android.os.SystemClock;
import android.preference.PreferenceManager;
import android.util.Log;
import com.littlefluffytoys.littlefluffylocationlibrary.LocationBroadcastService;
import com.littlefluffytoys.littlefluffylocationlibrary.LocationLibraryConstants;
import com.littlefluffytoys.littlefluffylocationlibrary.PassiveLocationChangedReceiver;

public class LocationLibrary {
    protected static boolean showDebugOutput = false;
    protected static boolean broadcastEveryLocationUpdate = false;
    private static final String TAG = "LocationLibrary";
    protected static String broadcastPrefix;
    private static boolean initialised;
    private static long alarmFrequency;
    private static int locationMaximumAge;

    static {
        initialised = false;
        alarmFrequency = 900000L;
        locationMaximumAge = 3600000;
    }

    protected static int getLocationMaximumAge() {
        return locationMaximumAge;
    }

    protected static long getAlarmFrequency() {
        return alarmFrequency;
    }

    public static void startAlarmAndListener(Context context) {
        if (showDebugOutput) {
            Log.d((String)"LittleFluffyLocationLibrary", (String)("LocationLibrary: startAlarmAndListener: alarmFrequency=" + (alarmFrequency == 900000L ? "default:" : "") + alarmFrequency / 1000L + " secs, locationMaximumAge=" + (locationMaximumAge == 3600000 ? "default:" : "") + locationMaximumAge / 1000 + " secs"));
        }
        PendingIntent alarmIntent = PendingIntent.getService((Context)context, (int)2, (Intent)new Intent(context, LocationBroadcastService.class), (int)0x8000000);
        AlarmManager am = (AlarmManager)context.getSystemService("alarm");
        am.cancel(alarmIntent);
        am.setInexactRepeating(2, SystemClock.elapsedRealtime(), LocationLibrary.getAlarmFrequency(), alarmIntent);
        if (LocationLibraryConstants.SUPPORTS_FROYO) {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            Intent passiveIntent = new Intent(context, PassiveLocationChangedReceiver.class);
            PendingIntent locationListenerPassivePendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)passiveIntent, (int)0x8000000);
            locationManager.requestLocationUpdates("passive", 0L, 0.0f, locationListenerPassivePendingIntent);
        }
        if (showDebugOutput) {
            Log.d((String)"LittleFluffyLocationLibrary", (String)"LocationLibrary: startAlarmAndListener completed");
        }
    }

    public static void stopAlarmAndListener(Context context) {
        PendingIntent alarmIntent = PendingIntent.getService((Context)context, (int)2, (Intent)new Intent(context, LocationBroadcastService.class), (int)0x8000000);
        AlarmManager am = (AlarmManager)context.getSystemService("alarm");
        am.cancel(alarmIntent);
        if (LocationLibraryConstants.SUPPORTS_FROYO) {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            Intent passiveIntent = new Intent(context, PassiveLocationChangedReceiver.class);
            PendingIntent locationListenerPassivePendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)passiveIntent, (int)0x8000000);
            locationManager.removeUpdates(locationListenerPassivePendingIntent);
        }
        if (showDebugOutput) {
            Log.d((String)"LittleFluffyLocationLibrary", (String)"LocationLibrary: stopAlarmAndListener completed");
        }
    }

    public static void initialiseLibrary(Context context, String broadcastPrefix) {
        if (!initialised) {
            if (showDebugOutput) {
                Log.d((String)"LittleFluffyLocationLibrary", (String)"LocationLibrary: initialiseLibrary");
            }
            LocationLibrary.broadcastPrefix = broadcastPrefix;
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
            if (!prefs.getBoolean("LFT_SP_KEY_RUN_ONCE", Boolean.FALSE.booleanValue())) {
                if (showDebugOutput) {
                    Log.d((String)"LittleFluffyLocationLibrary", (String)"LocationLibrary: initialiseLibrary: first time ever run -> start alarm and listener");
                }
                LocationLibrary.startAlarmAndListener(context);
                prefs.edit().putBoolean("LFT_SP_KEY_RUN_ONCE", Boolean.TRUE.booleanValue()).commit();
            }
            initialised = true;
        }
    }

    public static void initialiseLibrary(Context context, long alarmFrequency, int locationMaximumAge, String broadcastPrefix) {
        if (!initialised) {
            LocationLibrary.alarmFrequency = alarmFrequency;
            LocationLibrary.locationMaximumAge = locationMaximumAge;
            LocationLibrary.initialiseLibrary(context, broadcastPrefix);
        }
    }

    public static void initialiseLibrary(Context context, boolean broadcastEveryLocationUpdate, String broadcastPrefix) {
        if (!initialised) {
            LocationLibrary.broadcastEveryLocationUpdate = broadcastEveryLocationUpdate;
            LocationLibrary.initialiseLibrary(context, broadcastPrefix);
        }
    }

    public static void initialiseLibrary(Context context, long alarmFrequency, int locationMaximumAge, boolean broadcastEveryLocationUpdate, String broadcastPrefix) {
        if (!initialised) {
            LocationLibrary.broadcastEveryLocationUpdate = broadcastEveryLocationUpdate;
            LocationLibrary.initialiseLibrary(context, alarmFrequency, locationMaximumAge, broadcastPrefix);
        }
    }

    public static void forceLocationUpdate(Context context) {
        SharedPreferences.Editor prefsEditor = PreferenceManager.getDefaultSharedPreferences((Context)context).edit();
        prefsEditor.putLong("LFT_SP_KEY_LAST_LOCATION_UPDATE_TIME", 0L);
        prefsEditor.putLong("LFT_SP_KEY_LAST_LOCATION_SUBMIT_TIME", 0L);
        prefsEditor.commit();
        context.startService(new Intent(context, LocationBroadcastService.class));
    }

    public static void showDebugOutput(boolean showDebugOutput) {
        LocationLibrary.showDebugOutput = showDebugOutput;
    }
}

