/*
 * Decompiled with CFR 0.152.
 */
package com.littlefluffytoys.littlefluffylocationlibrary;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.format.DateFormat;
import java.io.Serializable;

public class LocationInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public long lastLocationUpdateTimestamp;
    public long lastLocationBroadcastTimestamp;
    public float lastLat;
    public float lastLong;
    public int lastAccuracy;

    public LocationInfo(Context context) {
        this.refresh(context);
    }

    public void refresh(Context context) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.lastLocationUpdateTimestamp = prefs.getLong("LFT_SP_KEY_LAST_LOCATION_UPDATE_TIME", 0L);
        this.lastLocationBroadcastTimestamp = prefs.getLong("LFT_SP_KEY_LAST_LOCATION_SUBMIT_TIME", 0L);
        this.lastLat = (float)((int)(prefs.getFloat("LFT_SP_KEY_LAST_LOCATION_UPDATE_LAT", -2.1474836E9f) * 1000000.0f)) / 1000000.0f;
        this.lastLong = (float)((int)(prefs.getFloat("LFT_SP_KEY_LAST_LOCATION_UPDATE_LNG", -2.1474836E9f) * 1000000.0f)) / 1000000.0f;
        this.lastAccuracy = prefs.getInt("LFT_SP_KEY_LAST_LOCATION_UPDATE_ACCURACY", Integer.MAX_VALUE);
    }

    public boolean anyLocationDataReceived() {
        return this.lastLocationUpdateTimestamp != 0L;
    }

    public boolean anyLocationDataBroadcast() {
        return this.lastLocationBroadcastTimestamp != 0L;
    }

    public boolean hasLatestDataBeenBroadcast() {
        return this.anyLocationDataBroadcast() && this.lastLocationUpdateTimestamp == this.lastLocationBroadcastTimestamp;
    }

    public long getTimestampAgeInSeconds() {
        return Math.max((System.currentTimeMillis() - this.lastLocationUpdateTimestamp) / 1000L, 0L);
    }

    public static String formatTimeAndDay(long timestamp, boolean includeSeconds) {
        return DateFormat.format((CharSequence)("kk:mm" + (includeSeconds ? ".ss" : "") + ", E"), (long)timestamp).toString();
    }

    public String toString() {
        return String.format("lastLocationUpdateTimestamp=%1$s lastLocationBroadcastTimestamp=%2$s lastLat=%3$.6f lastLong=%4$.6f lastAccuracy=%5$d", this.lastLocationUpdateTimestamp != 0L ? LocationInfo.formatTimeAndDay(this.lastLocationUpdateTimestamp, true) : "none", this.lastLocationBroadcastTimestamp != 0L ? LocationInfo.formatTimeAndDay(this.lastLocationBroadcastTimestamp, true) : "none", Float.valueOf(this.lastLat), Float.valueOf(this.lastLong), this.lastAccuracy);
    }
}

