/*
 * Decompiled with CFR 0.152.
 */
package com.littlefluffytoys.littlefluffylocationlibrary;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.preference.PreferenceManager;
import android.util.Log;
import com.littlefluffytoys.littlefluffylocationlibrary.LocationInfo;
import com.littlefluffytoys.littlefluffylocationlibrary.LocationLibrary;
import com.littlefluffytoys.littlefluffylocationlibrary.LocationLibraryConstants;
import com.littlefluffytoys.littlefluffylocationlibrary.PassiveLocationChangedReceiver;
import java.io.Serializable;

public class LocationBroadcastService
extends Service {
    private static final String TAG = "LocationBroadcastService";
    Runnable mTask = new Runnable(){

        public void run() {
            boolean stopServiceOnCompletion = true;
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)LocationBroadcastService.this.getBaseContext());
            long lastLocationUpdateTimestamp = prefs.getLong("LFT_SP_KEY_LAST_LOCATION_UPDATE_TIME", 0L);
            long lastLocationBroadcastTimestamp = prefs.getLong("LFT_SP_KEY_LAST_LOCATION_SUBMIT_TIME", 0L);
            if (lastLocationBroadcastTimestamp == lastLocationUpdateTimestamp) {
                if (LocationLibrary.showDebugOutput) {
                    Log.d((String)"LittleFluffyLocationLibrary", (String)"LocationBroadcastService: No new location update found");
                }
                if (System.currentTimeMillis() - lastLocationUpdateTimestamp > (long)LocationLibrary.getLocationMaximumAge()) {
                    stopServiceOnCompletion = !LocationBroadcastService.this.forceLocationUpdate();
                }
            } else {
                SharedPreferences.Editor prefsEditor = prefs.edit();
                prefsEditor.putLong("LFT_SP_KEY_LAST_LOCATION_SUBMIT_TIME", lastLocationUpdateTimestamp);
                prefsEditor.commit();
                LocationBroadcastService.sendBroadcast(LocationBroadcastService.this.getBaseContext(), prefs, true);
            }
            if (stopServiceOnCompletion) {
                LocationBroadcastService.this.stopSelf();
            }
        }
    };
    final LocationListener preGingerbreadUpdatesListener = new LocationListener(){

        public void onLocationChanged(Location location) {
            if (LocationLibrary.showDebugOutput) {
                Log.d((String)"LittleFluffyLocationLibrary", (String)("LocationBroadcastService: Single Location Update Received: " + location.getLatitude() + "," + location.getLongitude()));
            }
            ((LocationManager)LocationBroadcastService.this.getApplicationContext().getSystemService("location")).removeUpdates(LocationBroadcastService.this.preGingerbreadUpdatesListener);
            if (!LocationLibraryConstants.SUPPORTS_FROYO) {
                PassiveLocationChangedReceiver.processLocation((Context)LocationBroadcastService.this, location);
            }
            LocationBroadcastService.forceDelayedServiceCall(LocationBroadcastService.this.getApplicationContext(), 1);
            LocationBroadcastService.this.stopSelf();
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }
    };
    private final IBinder mBinder = new Binder(){

        protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            return super.onTransact(code, data, reply, flags);
        }
    };

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (LocationLibrary.showDebugOutput) {
            Log.d((String)"LittleFluffyLocationLibrary", (String)"LocationBroadcastService: onStartCommand");
        }
        new Thread(null, this.mTask, TAG).start();
        return 1;
    }

    public void onDestroy() {
        if (LocationLibrary.showDebugOutput) {
            Log.d((String)"LittleFluffyLocationLibrary", (String)"LocationBroadcastService: onDestroy");
        }
    }

    protected static void sendBroadcast(Context context, SharedPreferences prefs, boolean isPeriodicBroadcast) {
        Intent locationIntent = new Intent(String.valueOf(LocationLibrary.broadcastPrefix) + (isPeriodicBroadcast ? ".littlefluffylocationlibrary.LOCATION_CHANGED" : ".littlefluffylocationlibrary.LOCATION_CHANGED_TICK"));
        LocationInfo locationInfo = new LocationInfo(context);
        locationIntent.putExtra("com.littlefluffytoys.littlefluffylocationlibrary.LocationInfo", (Serializable)locationInfo);
        if (LocationLibrary.showDebugOutput) {
            Log.d((String)"LittleFluffyLocationLibrary", (String)("LocationBroadcastService: Broadcasting " + (isPeriodicBroadcast ? "periodic" : "latest") + " location update timed at " + LocationInfo.formatTimeAndDay(prefs.getLong("LFT_SP_KEY_LAST_LOCATION_UPDATE_TIME", System.currentTimeMillis()), true)));
        }
        context.sendBroadcast(locationIntent, "android.permission.ACCESS_FINE_LOCATION");
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    @TargetApi(value=9)
    public boolean forceLocationUpdate() {
        LocationManager locationManager = (LocationManager)this.getApplicationContext().getSystemService("location");
        Criteria criteria = new Criteria();
        criteria.setAccuracy(2);
        if (LocationLibraryConstants.SUPPORTS_GINGERBREAD) {
            if (LocationLibrary.showDebugOutput) {
                Log.d((String)"LittleFluffyLocationLibrary", (String)"LocationBroadcastService: Force a single location update, as current location is beyond the oldest location permitted");
            }
            Intent receiver = new Intent(this.getApplicationContext(), PassiveLocationChangedReceiver.class).addCategory("INTENT_CATEGORY_ONE_SHOT_UPDATE");
            PendingIntent oneshotReceiver = PendingIntent.getBroadcast((Context)this.getApplicationContext(), (int)0, (Intent)receiver, (int)0x8000000);
            try {
                locationManager.requestSingleUpdate(criteria, oneshotReceiver);
            }
            catch (IllegalArgumentException ex) {
                if (LocationLibrary.showDebugOutput) {
                    Log.w((String)"LittleFluffyLocationLibrary", (String)("LocationBroadcastService: IllegalArgumentException during call to locationManager.requestSingleUpdate - probable cause is that all location providers are off. Details: " + ex.getMessage()));
                }
            }
        } else {
            String provider;
            if (LocationLibrary.showDebugOutput) {
                Log.d((String)"LittleFluffyLocationLibrary", (String)"LocationBroadcastService: Force location updates (pre-Gingerbread), as current location is beyond the oldest location permitted");
            }
            if ((provider = locationManager.getBestProvider(criteria, true)) != null) {
                locationManager.requestLocationUpdates(provider, 0L, 0.0f, this.preGingerbreadUpdatesListener, this.getMainLooper());
                return true;
            }
        }
        return false;
    }

    public static void forceDelayedServiceCall(Context context, int delayInSeconds) {
        Intent serviceIntent = new Intent(context, LocationBroadcastService.class);
        PendingIntent pIntent = PendingIntent.getService((Context)context, (int)1, (Intent)serviceIntent, (int)0x40000000);
        AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
        alarm.set(0, System.currentTimeMillis() + (long)(delayInSeconds * 1000), pIntent);
    }
}

