package com.cookbook.open_gl;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

import android.opengl.GLSurfaceView;

/**
 * Render a tumbling Pyramid
 */

class PyramidRenderer implements GLSurfaceView.Renderer {
    public PyramidRenderer(boolean useTranslucentBackground) {
        mTranslucentBackground = useTranslucentBackground;
        mPyramid = new Pyramid();
    }

    public void onDrawFrame(GL10 gl) {
        /* clear the screen */
        gl.glClear(GL10.GL_COLOR_BUFFER_BIT | GL10.GL_DEPTH_BUFFER_BIT);

        /* draw a pyramid rotating */
        gl.glMatrixMode(GL10.GL_MODELVIEW);
        gl.glLoadIdentity();
        gl.glTranslatef(mCenter[0], mCenter[1], mCenter[2]);
        gl.glRotatef(mAngle,        0, 1, 0);
        gl.glRotatef(mAngle*0.25f,  1, 0, 0);

        gl.glEnableClientState(GL10.GL_VERTEX_ARRAY);
        gl.glEnableClientState(GL10.GL_COLOR_ARRAY);
        mPyramid.draw(gl);

        mAngle += mAngleDelta;

        /* draw it bouncing off the walls */
        mCenter[0] += mVel[0]*0.025f;
        mCenter[1] += mVel[1]*0.03535227f;

        if(Math.abs(mCenter[0])>4.0f) {
            mVel[0] = -mVel[0]; mAngleDelta=(float) (5*(0.5-Math.random()));
        }
        if(Math.abs(mCenter[1])>6.0f) {
            mVel[1] = -mVel[1]; mAngleDelta=(float) (5*(0.5-Math.random()));
        }       
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        gl.glViewport(0, 0, width, height);

        /* Set a new projection when the viewport is resized */
        float ratio = (float) width / height;
        gl.glMatrixMode(GL10.GL_PROJECTION);
        gl.glLoadIdentity();
        gl.glFrustumf(-ratio, ratio, -1, 1, 1, 20);
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        gl.glDisable(GL10.GL_DITHER);

        /* one-time OpenGL initialization */
        gl.glHint(GL10.GL_PERSPECTIVE_CORRECTION_HINT,
                GL10.GL_FASTEST);

        if (mTranslucentBackground) {
            gl.glClearColor(0,0,0,0);
        } else {
            gl.glClearColor(1,1,1,1);
        }
        gl.glEnable(GL10.GL_CULL_FACE);
        gl.glShadeModel(GL10.GL_SMOOTH);
        gl.glEnable(GL10.GL_DEPTH_TEST);
    }
    private boolean mTranslucentBackground;
    private Pyramid mPyramid;
    private float mAngle, mAngleDelta=0;
    private float mCenter[]={0,0,-10};
    private float mVel[]={1,1,1};
}